/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.dyeable_redstone_signal.common.world;

import com.google.common.collect.ImmutableSet;
import com.hexagram2021.dyeable_redstone_signal.common.block.ColorfulRedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.block.CommonRedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.register.DRSBlocks;
import com.hexagram2021.dyeable_redstone_signal.common.register.DRSItems;
import com.hexagram2021.dyeable_redstone_signal.common.util.DRSSounds;
import com.hexagram2021.dyeable_redstone_signal.common.util.RegistryHelper;
import com.hexagram2021.dyeable_redstone_signal.common.world.DRSTrades;
import com.hexagram2021.dyeable_redstone_signal.mixin.HeroGiftsTaskAccess;
import com.hexagram2021.dyeable_redstone_signal.mixin.StructureTemplatePoolAccess;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Villages {
    public static final ResourceLocation ENERGY_RESEARCHER = new ResourceLocation("dyeable_redstone_signal", "energy_researcher");

    public static void init() {
        HeroGiftsTaskAccess.getGifts().put((VillagerProfession)Registers.PROF_ENERGY_RESEARCHER.get(), new ResourceLocation("dyeable_redstone_signal", "gameplay/hero_of_the_village/energy_researcher_gift"));
    }

    public static void addAllStructuresToPool(RegistryAccess registryAccess) {
        Villages.addToPool(new ResourceLocation("village/plains/houses"), new ResourceLocation("dyeable_redstone_signal", "village/houses/plains_energy_researcher"), 5, registryAccess);
    }

    private static void addToPool(ResourceLocation poolName, ResourceLocation toAdd, int weight, RegistryAccess registryAccess) {
        Registry registry = registryAccess.m_175515_(Registries.f_256948_);
        StructureTemplatePoolAccess pool = (StructureTemplatePoolAccess)Objects.requireNonNull((StructureTemplatePool)registry.m_7745_(poolName), poolName.m_135815_());
        ArrayList<Pair<StructurePoolElement, Integer>> rawTemplates = pool.getRawTemplates() instanceof ArrayList ? pool.getRawTemplates() : new ArrayList<Pair<StructurePoolElement, Integer>>(pool.getRawTemplates());
        SinglePoolElement addedElement = (SinglePoolElement)SinglePoolElement.m_210526_((String)toAdd.toString()).apply(StructureTemplatePool.Projection.RIGID);
        rawTemplates.add((Pair<StructurePoolElement, Integer>)Pair.of((Object)addedElement, (Object)weight));
        pool.getTemplates().add((Object)addedElement);
        pool.setRawTemplates(rawTemplates);
    }

    @Mod.EventBusSubscriber(modid="dyeable_redstone_signal", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Registers {
        public static final DeferredRegister<PoiType> POINTS_OF_INTEREST = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"dyeable_redstone_signal");
        public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"dyeable_redstone_signal");
        public static final RegistryObject<PoiType> POI_REDSTONE_DYER = POINTS_OF_INTEREST.register("redstone_dyer", () -> Registers.createPOI(Registers.assembleStates((Block)DRSBlocks.REDSTONE_DYER.get())));
        public static final RegistryObject<VillagerProfession> PROF_ENERGY_RESEARCHER = PROFESSIONS.register(ENERGY_RESEARCHER.m_135815_(), () -> Registers.createProf(ENERGY_RESEARCHER, () -> POI_REDSTONE_DYER.getKey(), DRSSounds.VILLAGER_WORK_ENERGY_RESEARCHER));

        private static Collection<BlockState> assembleStates(Block block) {
            return block.m_49965_().m_61056_();
        }

        private static PoiType createPOI(Collection<BlockState> block) {
            return new PoiType((Set)ImmutableSet.copyOf(block), 1, 1);
        }

        private static VillagerProfession createProf(ResourceLocation name, Supplier<ResourceKey<PoiType>> poi, SoundEvent sound) {
            ResourceKey<PoiType> poiName = poi.get();
            return new VillagerProfession(name.toString(), p -> p.m_203565_(poiName), p -> p.m_203565_(poiName), ImmutableSet.of(), ImmutableSet.of(), sound);
        }

        public static void init(IEventBus bus) {
            POINTS_OF_INTEREST.register(bus);
            PROFESSIONS.register(bus);
        }
    }

    @Mod.EventBusSubscriber(modid="dyeable_redstone_signal", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent event) {
            Int2ObjectMap trades = event.getTrades();
            ResourceLocation currentVillagerProfession = RegistryHelper.getRegistryName(event.getType());
            if (ENERGY_RESEARCHER.equals((Object)currentVillagerProfession)) {
                ((List)trades.get(1)).add(new DRSTrades.EmeraldForItems((ItemLike)Items.f_42451_, 4, 1, 16, 2));
                ((List)trades.get(1)).add(new DRSTrades.EmeraldForItems((ItemLike)Items.f_42594_, 24, 1, 16, 2));
                ((List)trades.get(1)).add(new DRSTrades.EmeraldForItems((ItemLike)Items.f_42692_, 8, 1, 16, 2));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42498_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42494_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42495_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42492_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42490_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42496_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42538_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42491_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42540_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42537_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42536_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42489_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42493_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42497_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42535_), 1, 2, 12, 5));
                ((List)trades.get(2)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42539_), 1, 2, 12, 5));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.BLACK_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.BLUE_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.BROWN_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.CYAN_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.GRAY_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.GREEN_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.LIGHT_BLUE_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.LIGHT_GRAY_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.LIME_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.MAGENTA_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.ORANGE_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.PINK_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.PURPLE_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.RED_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.WHITE_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(3)).add(new DRSTrades.ItemsAndEmeraldsToItems((ItemLike)Items.f_42451_, 4, 1, ((ColorfulRedstoneWireBlock)((Object)DRSBlocks.YELLOW_REDSTONE_WIRE.get())).m_5456_(), 4, 12, 10));
                ((List)trades.get(4)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)((CommonRedstoneWireBlock)((Object)DRSBlocks.COMMON_REDSTONE_WIRE.get())).m_5456_()), 1, 2, 16, 15));
                ((List)trades.get(4)).add(new DRSTrades.EmeraldForItems((ItemLike)Items.f_42499_, 32, 1, 16, 30));
                ((List)trades.get(5)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)Items.f_42447_), 1, 1, 3, 30));
                ((List)trades.get(5)).add(new DRSTrades.EnchantedItemForEmeralds(Items.f_42392_, 4, 15, 10, true, 3, 30));
                ((List)trades.get(5)).add(new DRSTrades.ItemsForEmeralds(new ItemStack((ItemLike)DRSItems.REDSTONE_AMMETER.get()), 3, 1, 3, 30));
            }
        }
    }
}

